// Silicon Chip DLC Slave for WS2812 LEDs

#include "config.h"
#define _XTAL_FREQ (48000000L)
#include <xc.h>
#include "io.h"
#include "uart.h"
//#include "tmr2.h"
#include "brightness.h"

volatile unsigned char RGBdata[64][3]; //laid out for easy linear access by
                                       //assembly routine, colour order is GRB
unsigned char DLCdata[256];            //raw data from serial line
unsigned char baseAddress=0;           //for address offset
unsigned char outputMode=OUTPUT_RGB;   //colour mode

int main(void){
    unsigned char d;                 //received data byte
    unsigned char frame;             //frame error flag
    unsigned char byteCount=126;     //#of bytes into frame, >63 => error
    unsigned char frameType=0xFF;    //first byte of frame
    //unsigned char tcycles=0;
    //unsigned char outputMode=OUTPUT_WHITE;
    unsigned char i;
    unsigned int j;
    unsigned int brightness=15;    //for brightness mapping, index into brightnessMap[][]
    unsigned char dataChanged=0;   //set to flag if LEDs need to output
    unsigned char nLED=0;          //mapping of 1/4/16 LEDs, counted in bits to shift
    unsigned char iMax=21;         //upper limit for counting index when mapping    
    int adc;                       //temp store
    OSCCONbits.IRCF = 0b1111; //use 16MHz HFINTOSC x 3 =>48MHz clock =>12MHz instruction clock
    ioinit();
    uartInit();
    setOptions();
    while (1) {
        setOptions();
        //brightness = getADC(3)/64;   //0-1023 => 0-15
        //modified brightness/ LED  multimode mapping
        adc=getADC(3);
        nLED=0;
        while(adc>341){
            nLED=nLED+2;
            adc=adc-341;
        }
        brightness=adc/22;  //22x16=352, => 0-15                
        if(dataChanged>1){      //have received at least one full set of data
            if(outputMode==OUTPUT_WHITE){
                for(i=0;i<64;i++){
                    RGBdata[i][0]=brightnessMap[brightness][DLCdata[((i>>nLED)+baseAddress)&0x3F]];
                    RGBdata[i][1]=RGBdata[i][0];
                    RGBdata[i][2]=RGBdata[i][0];
                }                    
            }else{
                iMax=21;
                if(nLED==1){iMax=42;}   //not used at the moment, but in case we do
                if(nLED>1){iMax=64;}
                for(i=0;i<iMax;i++){      //map to RGB channels
                    RGBdata[i][1]=brightnessMap[brightness][DLCdata[((i>>nLED)*3+0+baseAddress)&0x3F]];//red
                    RGBdata[i][0]=brightnessMap[brightness][DLCdata[((i>>nLED)*3+1+baseAddress)&0x3F]];//green
                    RGBdata[i][2]=brightnessMap[brightness][DLCdata[((i>>nLED)*3+2+baseAddress)&0x3F]];//blue
                }                                        
                if(iMax<64){
                    for(i=iMax;i<64;i++){      //clear unused channels
                        RGBdata[i][1]=0;
                        RGBdata[i][0]=0;
                        RGBdata[i][2]=0;
                    }                                        
                }
            }
            sendLEDdata();
            dataChanged=0;          //reset flag
        }
        if(RCIF && RCIE){
            if(OERR){   //reset overflow error (serious, but better than locking up)
                CREN=0;
                CREN=1;
                //ignore any more data until next break
                byteCount=126;
                frameType=0xFF;                
            }
            RCIF=0;           //clear flag
            frame=FERR;
            d=RCREG;
            if(frame){
                if(d==0){               //start of frame
                    byteCount=0;        //reset
                    frameType=0xFF;
                }else{                  //data error
                    byteCount=126;      
                }                
            }else{                      //normal data
                if(byteCount==0){       //first byte of frame
                    frameType=d;
                    dataChanged++;      //data being received
                }else{                  //control bytes
                    if(frameType==0){
                        DLCdata[byteCount-1]=d; //raw data from serial line
                    }
                }
                if(byteCount<126){byteCount++;}     //keep count
            }
        }        
    }
}